<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;
    protected $fillable = array('name', 'price', 'time', 'description', 'image', 'rate', 'discount', 'category_id', 'restaurant_id', 'voucher_code', 'voucher_discount');

    public function restaurant()
    {
        return $this->belongsTo('App\Models\Restaurant');
    }

    public function product_category()
    {
        return $this->belongsTo('App\Models\ProductCategory');
    }

    public function orders()
    {
        return $this->hasMany('App\Models\Order');
    }

    public function product_reviews()
    {
        return $this->hasMany('App\Models\ProductReview');
    }

}